/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.server.IPECommands;
import filenet.vw.server.VWConfigInfo;
import java.io.Serializable;

abstract class VWPersistentCollection
implements Serializable {
    private static final long serialVersionUID = 7449L;
    protected String FWobNum = "F_WobNum";
    protected String name;
    protected IPECommands cmdSession = null;
    protected VWSession serviceSession;
    protected int userCentricServer = -1;
    protected int viewId = 0;
    protected int classId = 0;

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:38  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.27  $";
    }

    protected void setConfigInfo(VWConfigInfo c) {
        this.viewId = c.getViewId();
        this.classId = c.getClassId();
    }

    protected VWPersistentCollection(String name, VWSession serviceSession) throws VWException {
        this.name = name;
        this.serviceSession = serviceSession;
        String dest = this.getDestination(serviceSession.serviceName, serviceSession.isolatedRegion);
        this.cmdSession = serviceSession.getCmdSession().getIPECommandsForDest(dest);
    }

    protected VWPersistentCollection(String name, VWSession serviceSession, int userCentricServer) throws VWException {
        this.name = name;
        this.serviceSession = serviceSession;
        this.userCentricServer = userCentricServer;
        String dest = this.getDestination(serviceSession.serviceName, serviceSession.isolatedRegion);
        this.cmdSession = serviceSession.getCmdSession().getIPECommandsForDest(dest);
    }

    protected VWPersistentCollection(String name, VWSession serviceSession, IPECommands cmdSession) throws VWException {
        this.name = name;
        this.serviceSession = serviceSession;
        this.cmdSession = cmdSession;
    }

    public String getAuthoredName() {
        return this.authorStr(this.name);
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public VWSession getServiceSession() {
        return this.serviceSession;
    }

    protected abstract String getDestination(String var1, int var2);

    protected VWSession getSession() throws VWException {
        if (this.serviceSession != null) {
            return this.serviceSession;
        }
        return null;
    }

    protected String translateStr(String inStr) {
        VWSession session = null;
        try {
            session = this.getSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (session != null) {
            try {
                return session.translate(inStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inStr;
    }

    protected String[] translateArr(String[] inStrs) {
        VWSession session = null;
        if (inStrs == null) {
            return null;
        }
        try {
            session = this.getSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        int arrCount = inStrs.length;
        String[] outStrs = new String[arrCount];
        if (session != null) {
            for (int i = 0; i < arrCount; ++i) {
                try {
                    outStrs[i] = session.translate(inStrs[i]);
                    continue;
                }
                catch (Exception e) {
                    outStrs[i] = inStrs[i];
                }
            }
        }
        return outStrs;
    }

    protected String authorStr(String inStr) {
        VWSession session = null;
        try {
            session = this.getSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (session != null) {
            try {
                return session.translateToAuthored(inStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inStr;
    }
}

